'use client';

import { motion } from 'framer-motion';
import { Sparkles, MapPin, Calendar, Users } from 'lucide-react';

/**
 * Hero section component with animated introduction - Light Theme
 */
export default function Hero() {
  return (
    <section className="relative min-h-[70vh] flex items-center justify-center overflow-hidden pt-20 bg-gradient-to-b from-[#FFF5F5] via-[#FFF1F2] to-white">
      {/* Subtle pattern */}
      <div className="absolute inset-0 pattern-bg opacity-50" />
      
      {/* Decorative orbs - subtle on light theme */}
      <div className="absolute top-1/4 left-1/4 w-96 h-96 bg-[#E11D2E]/5 rounded-full blur-3xl" />
      <div className="absolute bottom-1/4 right-1/4 w-80 h-80 bg-[#FEE2E2]/50 rounded-full blur-3xl" />

      {/* Content */}
      <div className="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        {/* Badge */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5 }}
          className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-[#FEF3C7] border border-[#FCD34D]/30 mb-8"
        >
          <Sparkles className="w-4 h-4 text-[#D97706]" />
          <span className="text-sm font-medium text-[#D97706]">
            Powered by AI Discovery
          </span>
        </motion.div>

        {/* Heading */}
        <motion.h1
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5, delay: 0.1 }}
          className="font-heading text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-semibold text-gray-900 mb-6 leading-tight"
        >
          Discover the{' '}
          <span className="text-[#E11D2E]">Best Events</span>
          <br />
          Around the World
        </motion.h1>

        {/* Subtitle */}
        <motion.p
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5, delay: 0.2 }}
          className="text-lg sm:text-xl text-gray-500 max-w-2xl mx-auto mb-12"
        >
          From world-class conferences to spectacular festivals, find events 
          with 1000+ attendees across the globe.
        </motion.p>

        {/* Stats */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.5, delay: 0.3 }}
          className="flex flex-wrap items-center justify-center gap-8 sm:gap-16"
        >
          <div className="flex items-center gap-3">
            <Calendar className="w-6 h-6 text-[#E11D2E]" />
            <div className="text-left">
              <p className="text-2xl font-bold text-[#E11D2E]">50+</p>
              <p className="text-sm text-gray-500">Curated Events</p>
            </div>
          </div>
          
          <div className="flex items-center gap-3">
            <MapPin className="w-6 h-6 text-[#E11D2E]" />
            <div className="text-left">
              <p className="text-2xl font-bold text-[#E11D2E]">10+</p>
              <p className="text-sm text-gray-500">Countries</p>
            </div>
          </div>
          
          <div className="flex items-center gap-3">
            <Users className="w-6 h-6 text-[#E11D2E]" />
            <div className="text-left">
              <p className="text-2xl font-bold text-[#E11D2E]">1M+</p>
              <p className="text-sm text-gray-500">Total Attendees</p>
            </div>
          </div>
        </motion.div>
      </div>
    </section>
  );
}
